/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

abstract class ISO2022
extends Charset {
    private static final byte ISO_ESC = 27;
    private static final byte ISO_SI = 15;
    private static final byte ISO_SO = 14;
    private static final byte ISO_SS2_7 = 78;
    private static final byte ISO_SS3_7 = 79;
    private static final byte MSB = -128;
    private static final char REPLACE_CHAR = '\ufffd';
    private static final byte maxDesignatorLength = 3;

    public ISO2022(String string, String[] stringArray) {
        super(string, stringArray);
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected static class Encoder
    extends CharsetEncoder {
        private final byte SS2 = (byte)-114;
        private final byte P2 = (byte)-94;
        private final byte P3 = (byte)-93;
        private final byte MSB = (byte)-128;
        protected final byte maximumDesignatorLength = (byte)4;
        protected String SODesig;
        protected String SS2Desig = null;
        protected String SS3Desig = null;
        protected CharsetEncoder ISOEncoder;
        private boolean shiftout = false;
        private boolean SODesDefined = false;
        private boolean SS2DesDefined = false;
        private boolean SS3DesDefined = false;
        private boolean newshiftout = false;
        private boolean newSODesDefined = false;
        private boolean newSS2DesDefined = false;
        private boolean newSS3DesDefined = false;

        protected Encoder(Charset charset) {
            super(charset, 4.0f, 8.0f);
        }

        public boolean canEncode(char c) {
            return this.ISOEncoder.canEncode(c);
        }

        protected void implReset() {
            this.shiftout = false;
            this.SODesDefined = false;
            this.SS2DesDefined = false;
            this.SS3DesDefined = false;
        }

        private int unicodeToNative(char c, byte[] byArray) {
            int n;
            int n2 = 0;
            char[] cArray = new char[]{c};
            byte[] byArray2 = new byte[4];
            try {
                CharBuffer charBuffer = CharBuffer.wrap(cArray);
                ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                this.ISOEncoder.encode(charBuffer, byteBuffer, true);
                byteBuffer.flip();
                n = byteBuffer.remaining();
                byteBuffer.get(byArray2, 0, n);
            }
            catch (Exception exception) {
                return -1;
            }
            if (n == 2) {
                if (!this.SODesDefined) {
                    this.newSODesDefined = true;
                    byArray[0] = 27;
                    byte[] byArray3 = this.SODesig.getBytes();
                    System.arraycopy(byArray3, 0, byArray, 1, byArray3.length);
                    n2 = byArray3.length + 1;
                }
                if (!this.shiftout) {
                    this.newshiftout = true;
                    byArray[n2++] = 14;
                }
                byArray[n2++] = (byte)(byArray2[0] & 0x7F);
                byArray[n2++] = (byte)(byArray2[1] & 0x7F);
            } else {
                byte[] byArray4;
                if (byArray2[0] == -114 && byArray2[1] == -94) {
                    if (!this.SS2DesDefined) {
                        this.newSS2DesDefined = true;
                        byArray[0] = 27;
                        byArray4 = this.SS2Desig.getBytes();
                        System.arraycopy(byArray4, 0, byArray, 1, byArray4.length);
                        n2 = byArray4.length + 1;
                    }
                    byArray[n2++] = 27;
                    byArray[n2++] = 78;
                    byArray[n2++] = (byte)(byArray2[2] & 0x7F);
                    byArray[n2++] = (byte)(byArray2[3] & 0x7F);
                }
                if (byArray2[0] == -114 && byArray2[1] == 163) {
                    if (!this.SS3DesDefined) {
                        this.newSS3DesDefined = true;
                        byArray[0] = 27;
                        byArray4 = this.SS3Desig.getBytes();
                        System.arraycopy(byArray4, 0, byArray, 1, byArray4.length);
                        n2 = byArray4.length + 1;
                    }
                    byArray[n2++] = 27;
                    byArray[n2++] = 79;
                    byArray[n2++] = (byte)(byArray2[2] & 0x7F);
                    byArray[n2++] = (byte)(byArray2[3] & 0x7F);
                }
            }
            return n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = 0;
            boolean bl = false;
            byte[] byArray2 = new byte[8];
            this.newshiftout = this.shiftout;
            this.newSODesDefined = this.SODesDefined;
            this.newSS2DesDefined = this.SS2DesDefined;
            this.newSS3DesDefined = this.SS3DesDefined;
            try {
                for (n = n <= n2 ? n : n2; n < n2; ++n) {
                    byte[] byArray3 = byArray2;
                    if (cArray[n] < '\u0080') {
                        if (this.shiftout) {
                            this.newshiftout = false;
                            n5 = 2;
                            byArray3[0] = 15;
                            byArray3[1] = (byte)(cArray[n] & 0x7F);
                        } else {
                            n5 = 1;
                            byArray3[0] = (byte)(cArray[n] & 0x7F);
                        }
                        if (cArray[n] == '\n') {
                            this.newSODesDefined = false;
                            this.newSS2DesDefined = false;
                            this.newSS3DesDefined = false;
                        }
                    } else {
                        n5 = this.unicodeToNative(cArray[n], byArray3);
                    }
                    if (n4 - n3 < n5) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (int i = 0; i < n5; ++i) {
                        byArray[n3++] = byArray3[i];
                    }
                    this.shiftout = this.newshiftout;
                    this.SODesDefined = this.newSODesDefined;
                    this.SS2DesDefined = this.newSS2DesDefined;
                    this.SS3DesDefined = this.newSS3DesDefined;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = 0;
            boolean bl = false;
            byte[] byArray = new byte[8];
            this.newshiftout = this.shiftout;
            this.newSODesDefined = this.SODesDefined;
            this.newSS2DesDefined = this.SS2DesDefined;
            this.newSS3DesDefined = this.SS3DesDefined;
            int n2 = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    byte[] byArray2 = byArray;
                    char c = charBuffer.get();
                    if (c < '\u0080') {
                        if (this.shiftout) {
                            this.newshiftout = false;
                            n = 2;
                            byArray2[0] = 15;
                            byArray2[1] = (byte)(c & 0x7F);
                        } else {
                            n = 1;
                            byArray2[0] = (byte)(c & 0x7F);
                        }
                        if (c == '\n') {
                            this.newSODesDefined = false;
                            this.newSS2DesDefined = false;
                            this.newSS3DesDefined = false;
                        }
                    } else {
                        n = this.unicodeToNative(c, byArray2);
                    }
                    if (byteBuffer.remaining() < n) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (int i = 0; i < n; ++i) {
                        byteBuffer.put(byArray2[i]);
                    }
                    ++n2;
                    this.shiftout = this.newshiftout;
                    this.SODesDefined = this.newSODesDefined;
                    this.SS2DesDefined = this.newSS2DesDefined;
                    this.SS3DesDefined = this.newSS3DesDefined;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n2);
            }
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }

    protected static class Decoder
    extends CharsetDecoder {
        protected String[] SODesig;
        protected String[] SS2Desig = null;
        protected String[] SS3Desig = null;
        protected CharsetDecoder[] SODecoder;
        protected CharsetDecoder[] SS2Decoder = null;
        protected CharsetDecoder[] SS3Decoder = null;
        private static final byte SOFlag = 0;
        private static final byte SS2Flag = 1;
        private static final byte SS3Flag = 2;
        private int curSODes;
        private int curSS2Des;
        private int curSS3Des;
        private boolean shiftout;
        private CharsetDecoder[] tmpDecoder;

        protected Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected void implReset() {
            this.curSODes = 0;
            this.curSS2Des = 0;
            this.curSS3Des = 0;
            this.shiftout = false;
        }

        private char encode(byte by, byte by2, byte by3) {
            by = (byte)(by | 0xFFFFFF80);
            by2 = (byte)(by2 | 0xFFFFFF80);
            byte[] byArray = new byte[]{by, by2};
            char[] cArray = new char[1];
            int n = 0;
            int n2 = 0;
            switch (by3) {
                case 0: {
                    n2 = this.curSODes;
                    this.tmpDecoder = this.SODecoder;
                    break;
                }
                case 1: {
                    n2 = this.curSS2Des;
                    this.tmpDecoder = this.SS2Decoder;
                    break;
                }
                case 2: {
                    n2 = this.curSS3Des;
                    this.tmpDecoder = this.SS3Decoder;
                }
            }
            for (n = 0; n < this.tmpDecoder.length; ++n) {
                if (n2 != n) continue;
                try {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, 2);
                    CharBuffer charBuffer = CharBuffer.wrap(cArray, 0, 1);
                    this.tmpDecoder[n].decode(byteBuffer, charBuffer, true);
                    charBuffer.flip();
                    return charBuffer.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return '\ufffd';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = 0;
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n2 <= n3);
            char[] cArray = charBuffer.array();
            int n4 = charBuffer.arrayOffset() + charBuffer.position();
            int n5 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n4 <= n5);
            n4 = n4 <= n5 ? n4 : n5;
            int n6 = 0;
            int n7 = 0;
            byte by = 0;
            int n8 = 1;
            try {
                for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; n2 += n8) {
                    n6 = byArray[n2] & 0xFF;
                    block9 : switch (n6) {
                        case 14: {
                            this.shiftout = true;
                            n8 = 1;
                            break;
                        }
                        case 15: {
                            this.shiftout = false;
                            n8 = 1;
                            break;
                        }
                        case 27: {
                            int n9;
                            Object object;
                            int n10 = Math.min(3, byteBuffer.remaining());
                            byte[] byArray2 = new byte[n10];
                            if (n3 - n2 < n10 + 1) {
                                object = CoderResult.UNDERFLOW;
                                return object;
                            }
                            for (int i = 0; i < n10; ++i) {
                                byArray2[i] = byArray[n2 + i + 1];
                            }
                            object = new String(byArray2, 0, n10);
                            for (n9 = 0; n9 < this.SODesig.length; ++n9) {
                                if (((String)object).indexOf(this.SODesig[n9]) != 0) continue;
                                this.curSODes = n9;
                                n = this.SODesig[n9].length();
                                n8 = n + 1;
                                break;
                            }
                            if (n9 != this.SODesig.length) break;
                            for (n9 = 0; n9 < this.SS2Desig.length; ++n9) {
                                if (((String)object).indexOf(this.SS2Desig[n9]) != 0) continue;
                                this.curSS2Des = n9;
                                n = this.SS2Desig[n9].length();
                                break;
                            }
                            if (n9 != this.SS2Desig.length) break;
                            for (n9 = 0; n9 < this.SS3Desig.length; ++n9) {
                                if (((String)object).indexOf(this.SS3Desig[n9]) != 0) continue;
                                this.curSS3Des = n9;
                                n = this.SS3Desig[n9].length();
                                break;
                            }
                            if (n9 != this.SS3Desig.length) break;
                            switch (n6) {
                                case 78: {
                                    if (n3 - n2 < 3) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    n7 = byArray[n2 + 1];
                                    by = byArray[n2 + 1];
                                    if (n5 - n4 < 1) {
                                        CoderResult coderResult = CoderResult.OVERFLOW;
                                        return coderResult;
                                    }
                                    cArray[n4] = this.encode((byte)n7, by, (byte)1);
                                    ++n4;
                                    n = 3;
                                    n8 = 3;
                                    break block9;
                                }
                                case 79: {
                                    if (n3 - n2 < 3) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    n7 = byArray[n2 + 1];
                                    by = byArray[n2 + 1];
                                    if (n5 - n4 < 1) {
                                        CoderResult coderResult = CoderResult.OVERFLOW;
                                        return coderResult;
                                    }
                                    cArray[n4] = this.encode((byte)n7, by, (byte)2);
                                    ++n4;
                                    n = 3;
                                    break block9;
                                }
                            }
                            n = 0;
                            break;
                        }
                        default: {
                            if (n5 - n4 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (!this.shiftout) {
                                cArray[n4++] = (char)byArray[n2];
                                n8 = 1;
                                break;
                            }
                            if (n5 - n4 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (n3 - n2 < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n7 = byArray[n2 + 1] & 0xFF;
                            cArray[n4++] = this.encode((byte)n6, (byte)n7, (byte)0);
                            n8 = 2;
                        }
                    }
                    n8 = 0;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n2 - byteBuffer.arrayOffset());
                charBuffer.position(n4 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            Object object;
            int n = byteBuffer.position();
            byte by = 0;
            int n2 = 0;
            byte by2 = 0;
            int n3 = 0;
            int n4 = 1;
            try {
                while (byteBuffer.hasRemaining()) {
                    by = byteBuffer.get();
                    block10 : switch (by) {
                        case 14: {
                            this.shiftout = true;
                            n4 = 1;
                            break;
                        }
                        case 15: {
                            this.shiftout = false;
                            n4 = 1;
                            break;
                        }
                        case 27: {
                            int n5;
                            Object object2;
                            int n6 = Math.min(3, byteBuffer.remaining());
                            object = new byte[n6];
                            if (byteBuffer.remaining() < n6 + 1) {
                                object2 = CoderResult.UNDERFLOW;
                                return object2;
                            }
                            for (int i = 0; i < n6; ++i) {
                                object[i] = byteBuffer.get();
                            }
                            object2 = new String((byte[])object, 0, n6);
                            for (n5 = 0; n5 < this.SODesig.length; ++n5) {
                                if (((String)object2).indexOf(this.SODesig[n5]) != 0) continue;
                                this.curSODes = n5;
                                n3 = this.SODesig[n5].length();
                                n4 = n3 + 1;
                                break;
                            }
                            if (n5 != this.SODesig.length) break;
                            for (n5 = 0; n5 < this.SS2Desig.length; ++n5) {
                                if (((String)object2).indexOf(this.SS2Desig[n5]) != 0) continue;
                                this.curSS2Des = n5;
                                n3 = this.SS2Desig[n5].length();
                                break;
                            }
                            if (n5 != this.SS2Desig.length) break;
                            for (n5 = 0; n5 < this.SS3Desig.length; ++n5) {
                                if (((String)object2).indexOf(this.SS3Desig[n5]) != 0) continue;
                                this.curSS3Des = n5;
                                n3 = this.SS3Desig[n5].length();
                                break;
                            }
                            if (n5 != this.SS3Desig.length) break;
                            switch (by) {
                                case 78: {
                                    if (byteBuffer.remaining() < 3) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    n2 = byteBuffer.get();
                                    by2 = byteBuffer.get();
                                    if (charBuffer.remaining() < 1) {
                                        CoderResult coderResult = CoderResult.OVERFLOW;
                                        return coderResult;
                                    }
                                    charBuffer.put(this.encode((byte)n2, by2, (byte)1));
                                    n3 = 3;
                                    n4 = 3;
                                    break block10;
                                }
                                case 79: {
                                    if (byteBuffer.remaining() < 2) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    n2 = byteBuffer.get();
                                    by2 = byteBuffer.get();
                                    if (charBuffer.remaining() < 1) {
                                        CoderResult coderResult = CoderResult.OVERFLOW;
                                        return coderResult;
                                    }
                                    charBuffer.put(this.encode((byte)n2, by2, (byte)2));
                                    n3 = 3;
                                    break block10;
                                }
                            }
                            n3 = 0;
                            break;
                        }
                        default: {
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (!this.shiftout) {
                                charBuffer.put((char)by);
                                n4 = 1;
                                break;
                            }
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n2 = byteBuffer.get() & 0xFF;
                            charBuffer.put(this.encode(by, (byte)n2, (byte)0));
                            n4 = 2;
                        }
                    }
                    n += n4;
                    n4 = 0;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                object = CoderResult.OVERFLOW;
                return object;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }
}

