/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

abstract class DoubleByteDecoder
extends CharsetDecoder {
    private short[] index1;
    private String[] index2;
    protected int start;
    protected int end;
    protected static final char REPLACE_CHAR = '\ufffd';
    protected char highSurrogate;
    protected char lowSurrogate;

    protected DoubleByteDecoder(Charset charset, short[] sArray, String[] stringArray, int n, int n2) {
        super(charset, 0.5f, 1.0f);
        this.index1 = sArray;
        this.index2 = stringArray;
        this.start = n;
        this.end = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        assert (n <= n2);
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        assert (n3 <= n4);
        n3 = n3 <= n4 ? n3 : n4;
        try {
            int n5;
            for (n = n <= n2 ? n : n2; n < n2; n += n5) {
                int n6 = byArray[n];
                n5 = 1;
                int n7 = 1;
                this.lowSurrogate = '\u0000';
                this.highSurrogate = '\u0000';
                char c = this.decodeSingle(n6);
                if (c == '\ufffd') {
                    n6 &= 0xFF;
                    if (n2 - n < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int n8 = byArray[n + 1] & 0xFF;
                    c = this.decodeDouble(n6, n8);
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    n5 = 2;
                    int n9 = n7 = this.highSurrogate > '\u0000' ? 2 : 1;
                }
                if (n4 - n3 < n7) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (n7 == 2) {
                    cArray[n3++] = this.highSurrogate;
                    cArray[n3++] = this.lowSurrogate;
                    continue;
                }
                cArray[n3++] = c;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            charBuffer.position(n3 - charBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        int n2 = 0;
        int n3 = 0;
        try {
            while (byteBuffer.hasRemaining()) {
                int n4 = byteBuffer.get();
                n2 = 1;
                n3 = 1;
                this.lowSurrogate = '\u0000';
                this.highSurrogate = '\u0000';
                char c = this.decodeSingle(n4);
                if (c == '\ufffd') {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int n5 = byteBuffer.get() & 0xFF;
                    n2 = 2;
                    c = this.decodeDouble(n4 &= 0xFF, n5);
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(2);
                        return coderResult;
                    }
                    int n6 = n3 = this.highSurrogate > '\u0000' ? 2 : 1;
                }
                if (charBuffer.remaining() < n3) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n += n2;
                if (n3 == 2) {
                    charBuffer.put(this.highSurrogate);
                    charBuffer.put(this.lowSurrogate);
                    continue;
                }
                charBuffer.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }

    protected char decodeSingle(int n) {
        if (n >= 0) {
            return (char)n;
        }
        return '\ufffd';
    }

    protected char decodeDouble(int n, int n2) {
        if (n < 0 || n > this.index1.length || n2 < this.start || n2 > this.end) {
            return '\ufffd';
        }
        int n3 = (this.index1[n] & 0xF) * (this.end - this.start + 1) + (n2 - this.start);
        return this.index2[this.index1[n] >> 4].charAt(n3);
    }
}

