/*
 * Decompiled with CFR 0.152.
 */
package letterscapes;

import letterscapes.bkey;
import letterscapes.key;
import letterscapes.skey;

public class triple {
    public final int LINEAR = 0;
    public final int EASEIN = 1;
    public final int EASEOUT = 2;
    public final int EASEINOUT = 3;
    public final int EASEOUT2 = 4;
    public final int JUMP = 5;
    final int MAXKEYS = 10;
    float in;
    float out;
    float now;
    public float x;
    public float y;
    public float z;
    private int nkeys;
    private key[] keys;
    public boolean repeat = false;
    public boolean moving = true;
    public boolean pause = false;
    protected boolean valid = false;

    public triple(float myin, float myout) {
        this.in = myin;
        this.out = myout;
        this.nkeys = 0;
        this.keys = new key[10];
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.valid = true;
    }

    public triple(float myx, float myy, float myz) {
        this.x = myx;
        this.y = myy;
        this.z = myz;
        this.in = 0.0f;
        this.out = 0.0f;
    }

    void restart(float myin, float myout) {
        this.in = myin;
        this.out = myout;
        if (this.nkeys > 0) {
            this.keys[0].x = this.x;
            this.keys[0].y = this.y;
            this.keys[0].z = this.z;
            this.keys[0].t = 0.0f;
            this.keys[0].type = this.keys[this.nkeys - 1].type;
            this.nkeys = 1;
        } else {
            this.nkeys = 0;
        }
        this.moving = true;
    }

    float calcdt(float dt, int type) {
        if (type == 1) {
            dt = 1.0f - (dt - 1.0f) * (dt - 1.0f);
        } else if (type == 2) {
            dt *= dt;
        } else if (type == 3) {
            if (dt < 0.5f) {
                dt = dt * 2.0f * (dt * 2.0f) * 0.5f;
            } else if ((double)dt > 0.5) {
                dt = (1.0f - ((dt - 0.5f) * 2.0f - 1.0f) * ((dt - 0.5f) * 2.0f - 1.0f)) * 0.5f + 0.5f;
            }
        } else if (type == 4) {
            dt = dt * dt * (dt * dt);
        } else if (type != 0 && type == 5) {
            dt = 0.0f;
        }
        return dt;
    }

    float update(float time) {
        float dt;
        if (this.pause) {
            dt = time - this.now;
            this.in += dt;
            this.out += dt;
        }
        this.now = time;
        if (time >= this.in && time <= this.out) {
            float t = time - this.in;
            int i = 0;
            while (i < this.nkeys && t > this.keys[i].t) {
                ++i;
            }
            if (this.nkeys == 0) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 0.0f;
            } else if (i >= this.nkeys) {
                i = this.nkeys - 1;
                this.x = this.keys[i].x;
                this.y = this.keys[i].y;
                this.z = this.keys[i].z;
            } else if (i == 0) {
                this.x = this.keys[i].x;
                this.y = this.keys[i].y;
                this.z = this.keys[i].z;
            } else if (this.keys[i].getClass().getName().endsWith("bkey")) {
                float x0 = this.keys[i - 1].x;
                float y0 = this.keys[i - 1].y;
                float z0 = this.keys[i - 1].z;
                float x1 = ((bkey)this.keys[i]).x1;
                float y1 = ((bkey)this.keys[i]).y1;
                float z1 = ((bkey)this.keys[i]).z1;
                float x2 = ((bkey)this.keys[i]).x2;
                float y2 = ((bkey)this.keys[i]).y2;
                float z2 = ((bkey)this.keys[i]).z2;
                float x3 = this.keys[i].x;
                float y3 = this.keys[i].y;
                float z3 = this.keys[i].z;
                dt = (t - this.keys[i - 1].t) / (this.keys[i].t - this.keys[i - 1].t);
                dt = this.calcdt(dt, this.keys[i].type);
                float u = 1.0f - dt;
                float trip = 3.0f * dt * u;
                float c0 = u * u * u;
                float c1 = trip * u;
                float c2 = trip * dt;
                float c3 = dt * dt * dt;
                this.x = c0 * x0 + c1 * x1 + c2 * x2 + c3 * x3;
                this.y = c0 * y0 + c1 * y1 + c2 * y2 + c3 * y3;
                this.z = c0 * z0 + c1 * z1 + c2 * z2 + c3 * z3;
            } else {
                float x0 = this.keys[i - 1].x;
                float y0 = this.keys[i - 1].y;
                float z0 = this.keys[i - 1].z;
                float x1 = this.keys[i].x;
                float y1 = this.keys[i].y;
                float z1 = this.keys[i].z;
                dt = (t - this.keys[i - 1].t) / (this.keys[i].t - this.keys[i - 1].t);
                dt = this.calcdt(dt, this.keys[i].type);
                this.x = x0 + dt * (x1 - x0);
                this.y = y0 + dt * (y1 - y0);
                this.z = z0 + dt * (z1 - z0);
            }
            this.moving = true;
            return t / (this.out - this.in);
        }
        if (this.repeat) {
            this.out = time + (this.out - this.in);
            this.in = time;
            this.now = time;
            this.moving = true;
            return 0.0f;
        }
        int i = 0;
        if (this.nkeys > 0) {
            i = this.nkeys - 1;
            this.x = this.keys[i].x;
            this.y = this.keys[i].y;
            this.z = this.keys[i].z;
        }
        this.moving = false;
        return 1.0f;
    }

    void moveto(float time, float x, float y, float z) {
        if (this.nkeys < 10) {
            this.keys[this.nkeys] = new skey(x, y, z, time, 5);
            ++this.nkeys;
        }
    }

    void lineto(float time, float x, float y, float z, int type) {
        if (this.nkeys < 10) {
            this.keys[this.nkeys] = new skey(x, y, z, time, type);
            ++this.nkeys;
        }
    }

    void linetoadd(float time, float x, float y, float z, int type) {
        if (this.nkeys < 10) {
            this.keys[this.nkeys] = new skey(x, y, z, time, type);
            ++this.nkeys;
        } else if (this.nkeys == 10) {
            int i = 0;
            while (i < 9) {
                this.keys[i] = this.keys[i + 1];
                ++i;
            }
            this.keys[this.nkeys - 1] = new skey(x, y, z, time, type);
        }
    }

    void curveto(float time, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, int type) {
        if (this.nkeys < 10) {
            this.keys[this.nkeys] = new bkey(x1, y1, z1, x2, y2, z2, x3, y3, z3, time, type);
            ++this.nkeys;
        }
    }

    int getnkeys() {
        return this.nkeys;
    }
}

