/*
 * Decompiled with CFR 0.152.
 */
package letterscapes;

import java.awt.Graphics;
import java.awt.Polygon;

class tools2d {
    tools2d() {
    }

    static float area2(float ax, float ay, float bx, float by, float cx, float cy) {
        return (ax - cx) * (by - cy) - (ay - cy) * (bx - cx);
    }

    static boolean insideTriangle(float ax, float ay, float bx, float by, float cx, float cy, float px, float py) {
        return tools2d.area2(ax, ay, bx, by, px, py) >= 0.0f && tools2d.area2(bx, by, cx, cy, px, py) >= 0.0f && tools2d.area2(cx, cy, ax, ay, px, py) >= 0.0f;
    }

    static void triangulate(Polygon P, Polygon[] tr) {
        int n = P.npoints;
        int j = n - 1;
        int iA = 0;
        int[] next = new int[n];
        int i = 0;
        while (i < n) {
            next[j] = i;
            j = i++;
        }
        int k = 0;
        while (k < n - 2) {
            boolean triaFound = false;
            int count = 0;
            while (!triaFound && ++count < n) {
                float ax = P.xpoints[iA];
                float ay = P.ypoints[iA];
                int iB = next[iA];
                float bx = P.xpoints[iB];
                float by = P.ypoints[iB];
                int iC = next[iB];
                float cx = P.xpoints[iC];
                float cy = P.ypoints[iC];
                if (tools2d.area2(ax, ay, bx, by, cx, cy) >= 0.0f) {
                    j = next[iC];
                    while (j != iA && !tools2d.insideTriangle(ax, ay, bx, by, cx, cy, P.xpoints[j], P.ypoints[j])) {
                        j = next[j];
                    }
                    if (j == iA) {
                        tr[k] = new Polygon();
                        tr[k].addPoint((int)ax, (int)ay);
                        tr[k].addPoint((int)bx, (int)by);
                        tr[k].addPoint((int)cx, (int)cy);
                        next[iA] = iC;
                        triaFound = true;
                    }
                }
                iA = next[iA];
            }
            if (count == n) {
                System.out.println("Not a simple polygon or vertex sequence not counter-clockwise.");
            }
            ++k;
        }
    }

    static void triangulateFill(Graphics g, Polygon P) {
        int n = P.npoints;
        int j = n - 1;
        int iA = 0;
        int[] next = new int[n];
        int i = 0;
        while (i < n) {
            next[j] = i;
            j = i++;
        }
        int k = 0;
        while (k < n - 2) {
            boolean triaFound = false;
            int count = 0;
            while (!triaFound && ++count < n) {
                float ax = P.xpoints[iA];
                float ay = P.ypoints[iA];
                int iB = next[iA];
                float bx = P.xpoints[iB];
                float by = P.ypoints[iB];
                int iC = next[iB];
                float cx = P.xpoints[iC];
                float cy = P.ypoints[iC];
                if (tools2d.area2(ax, ay, bx, by, cx, cy) >= 0.0f) {
                    j = next[iC];
                    while (j != iA && !tools2d.insideTriangle(ax, ay, bx, by, cx, cy, P.xpoints[j], P.ypoints[j])) {
                        j = next[j];
                    }
                    if (j == iA) {
                        Polygon tr = new Polygon();
                        tr.addPoint((int)ax, (int)ay);
                        tr.addPoint((int)bx, (int)by);
                        tr.addPoint((int)cx, (int)cy);
                        g.fillPolygon(tr);
                        next[iA] = iC;
                        triaFound = true;
                    }
                }
                iA = next[iA];
            }
            if (count == n) {
                System.out.println("Not a simple polygon or vertex sequence not counter-clockwise.");
            }
            ++k;
        }
    }

    static float manhattan2(float px, float py, float qx, float qy) {
        float dx = px - qx;
        float dy = py - qy;
        return (dx > 0.0f ? dx : -dx) + (dy > 0.0f ? dy : -dy);
    }

    static float distance2(float px, float py, float qx, float qy) {
        float dx = px - qx;
        float dy = py - qy;
        return dx * dx + dy * dy;
    }
}

