/*
 * Decompiled with CFR 0.152.
 */
package letterscapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import letterscapes.lsRect;
import letterscapes.pobj;

public class graphics3d {
    final int maxstack = 10;
    final int maxobs = 1000;
    final int LEFT = 0;
    final int RIGHT = 1;
    final int CENTER = 2;
    final int BOTTOM = 3;
    final int TOP = 4;
    final int ERROR = -9999;
    private float[][] m = new float[4][4];
    private float[][] tmp1 = new float[4][4];
    private float[][] tmp2 = new float[4][4];
    private float[][][] stack = new float[10][4][4];
    private int ind = 0;
    private float[] scr1d = new float[4];
    private float[] new1d = new float[4];
    private float[] cur1d = new float[4];
    private int penx;
    private int peny;
    private int begx;
    private int begy;
    private int gx;
    private int gy;
    private pobj[] obs = new pobj[1000];
    private int nmob;
    public boolean drawasyougo = false;
    public boolean printoutai = false;
    Vector rects = new Vector();
    Vector rectstemp = new Vector();
    Vector framerects = new Vector();
    Vector vectorart = new Vector();
    public boolean firstprintoutai = false;

    public graphics3d(int gx, int gy) {
        this.makeidentity(this.m);
        int i = 0;
        while (i < 10) {
            this.makeidentity(this.stack[i]);
            ++i;
        }
        this.gx = gx;
        this.gy = gy;
        this.nmob = 0;
        this.obs[this.nmob] = new pobj();
        ++this.nmob;
    }

    public void push() {
        if (this.ind == 9) {
            System.out.println("stack overflow");
            return;
        }
        this.copy2d(this.stack[this.ind], this.m);
        ++this.ind;
        this.copy2d(this.stack[this.ind], this.m);
    }

    public void pop() {
        --this.ind;
        if (this.ind < 0) {
            System.out.println("stack underflow");
            return;
        }
        this.copy2d(this.m, this.stack[this.ind]);
    }

    public void copy1d(float[] b, float[] a) {
        int i = 0;
        while (i < 4) {
            b[i] = a[i];
            ++i;
        }
    }

    public void copy2d(float[][] b, float[][] a) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                b[i][j] = a[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void makeidentity(float[][] a) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                a[i][j] = i == j ? 1.0f : 0.0f;
                ++j;
            }
            ++i;
        }
    }

    public void transform(float[] v) {
        this.new1d[0] = this.m[0][0] * v[0] + this.m[0][1] * v[1] + this.m[0][2] * v[2] + this.m[0][3] * v[3];
        this.new1d[1] = this.m[1][0] * v[0] + this.m[1][1] * v[1] + this.m[1][2] * v[2] + this.m[1][3] * v[3];
        this.new1d[2] = this.m[2][0] * v[0] + this.m[2][1] * v[1] + this.m[2][2] * v[2] + this.m[2][3] * v[3];
        this.new1d[3] = 1.0f;
    }

    public void translate(float x, float y, float z) {
        this.makeidentity(this.tmp1);
        this.tmp1[0][3] = x;
        this.tmp1[1][3] = y;
        this.tmp1[2][3] = z;
        this.mult2d(this.tmp2, this.m, this.tmp1);
        this.copy2d(this.m, this.tmp2);
    }

    public void scale(float x, float y, float z) {
        this.makeidentity(this.tmp1);
        this.tmp1[0][0] = x;
        this.tmp1[1][1] = y;
        this.tmp1[2][2] = z;
        this.mult2d(this.tmp2, this.m, this.tmp1);
        this.copy2d(this.m, this.tmp2);
    }

    double deg2rad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public void rotateD(float x, float y, float z) {
        float sinx = (float)Math.sin(this.deg2rad(x));
        float siny = (float)Math.sin(this.deg2rad(y));
        float sinz = (float)Math.sin(this.deg2rad(z));
        float cosx = (float)Math.cos(this.deg2rad(x));
        float cosy = (float)Math.cos(this.deg2rad(y));
        float cosz = (float)Math.cos(this.deg2rad(z));
        this.tmp1[0][0] = cosy * cosz - sinx * siny * sinz;
        this.tmp1[0][1] = cosz * sinx * siny + cosy * sinz;
        this.tmp1[0][2] = -cosx * siny;
        this.tmp1[0][3] = 0.0f;
        this.tmp1[1][0] = -cosx * sinz;
        this.tmp1[1][1] = cosx * cosz;
        this.tmp1[1][2] = sinx;
        this.tmp1[1][3] = 0.0f;
        this.tmp1[2][0] = cosz * siny + cosy * sinx * sinz;
        this.tmp1[2][1] = -(cosy * cosz * sinx) + siny * sinz;
        this.tmp1[2][2] = cosx * cosy;
        this.tmp1[2][3] = 0.0f;
        this.tmp1[3][0] = 0.0f;
        this.tmp1[3][1] = 0.0f;
        this.tmp1[3][2] = 0.0f;
        this.tmp1[3][3] = 1.0f;
        this.mult2d(this.tmp2, this.m, this.tmp1);
        this.copy2d(this.m, this.tmp2);
    }

    public void rotateR(float x, float y, float z) {
        float sinx = (float)Math.sin(x);
        float siny = (float)Math.sin(y);
        float sinz = (float)Math.sin(z);
        float cosx = (float)Math.cos(x);
        float cosy = (float)Math.cos(y);
        float cosz = (float)Math.cos(z);
        this.tmp1[0][0] = cosy * cosz - sinx * siny * sinz;
        this.tmp1[0][1] = cosz * sinx * siny + cosy * sinz;
        this.tmp1[0][2] = -cosx * siny;
        this.tmp1[0][3] = 0.0f;
        this.tmp1[1][0] = -cosx * sinz;
        this.tmp1[1][1] = cosx * cosz;
        this.tmp1[1][2] = sinx;
        this.tmp1[1][3] = 0.0f;
        this.tmp1[2][0] = cosz * siny + cosy * sinx * sinz;
        this.tmp1[2][1] = -(cosy * cosz * sinx) + siny * sinz;
        this.tmp1[2][2] = cosx * cosy;
        this.tmp1[2][3] = 0.0f;
        this.tmp1[3][0] = 0.0f;
        this.tmp1[3][1] = 0.0f;
        this.tmp1[3][2] = 0.0f;
        this.tmp1[3][3] = 1.0f;
        this.mult2d(this.tmp2, this.m, this.tmp1);
        this.copy2d(this.m, this.tmp2);
    }

    public void mult2d(float[][] c, float[][] a, float[][] b) {
        int j = 0;
        while (j < 4) {
            int i = 0;
            while (i < 4) {
                float tot = 0.0f;
                int m = 0;
                while (m < 4) {
                    tot += b[m][j] * a[i][m];
                    ++m;
                }
                c[i][j] = tot;
                ++i;
            }
            ++j;
        }
    }

    public void adddiLine(int x1, int y1, int x2, int y2, Color color) {
        pobj line = new pobj();
        line.setcolor(color);
        line.p.addPoint(x1, y1);
        line.p.addPoint(x2, y2);
        this.vectorart.addElement(line);
    }

    public void drawdiVectorArt(Graphics g) {
        int j = 0;
        while (j < this.vectorart.size()) {
            pobj newp = (pobj)this.vectorart.elementAt(j);
            g.setColor(newp.c);
            g.drawPolygon(newp.p);
            ++j;
        }
    }

    public void flushpolys() {
        this.nmob = 0;
        this.rects.removeAllElements();
        this.framerects.removeAllElements();
        this.vectorart.removeAllElements();
    }

    public void flushlastpoly() {
        if (this.nmob > 0) {
            --this.nmob;
            this.obs[this.nmob] = new pobj();
        }
    }

    public void poplastpoly() {
        this.flushlastpoly();
    }

    public Polygon getlastpoly() {
        if (this.nmob > 0) {
            return this.obs[this.nmob - 1].p;
        }
        return null;
    }

    public int getpersx(float[] v) {
        float dfac = 750.0f;
        int x = (int)((float)(this.gx / 2) + v[0] * -dfac * (1.0f / v[2]));
        if (v[2] >= 0.0f) {
            return -9999;
        }
        if (x > 100 * this.gx || x < -99 * this.gx) {
            return -9999;
        }
        return x;
    }

    public int getpersy(float[] v) {
        float dfac = 750.0f;
        int y = (int)((float)(this.gy / 2) + v[1] * -dfac * (1.0f / v[2]));
        if (v[2] >= 0.0f) {
            return -9999;
        }
        if (y > 100 * this.gy || y < -99 * this.gy) {
            return -9999;
        }
        return y;
    }

    public float getpersxf(float[] v) {
        float dfac = 750.0f;
        return (float)(this.gx / 2) + v[0] * -dfac * (1.0f / v[2]);
    }

    public float getpersyf(float[] v) {
        float dfac = 750.0f;
        return (float)(this.gy / 2) + v[1] * -dfac * (1.0f / v[2]);
    }

    public void drawString(Graphics g, String s, int halign, int valign) {
        int x = halign == 2 ? -g.getFontMetrics().stringWidth(s) / 2 : (halign == 1 ? -g.getFontMetrics().stringWidth(s) : 0);
        int y = valign == 4 ? g.getFontMetrics().getHeight() : (valign == 2 ? g.getFontMetrics().getHeight() / 2 : 0);
        g.drawString(s, this.penx + x, this.peny + y);
    }

    public void drawString(Graphics g, String s) {
        this.drawString(g, s, 0, 3);
    }

    public void add2drect(Graphics g, int x, int y, int w, int h) {
        if (this.nmob < 1000) {
            this.obs[this.nmob] = new pobj();
            this.obs[this.nmob].p.addPoint(x, y);
            this.obs[this.nmob].p.addPoint(x + w, y);
            this.obs[this.nmob].p.addPoint(x + w, y + h);
            this.obs[this.nmob].p.addPoint(x, y + h);
            this.obs[this.nmob].p.addPoint(x, y);
            ++this.nmob;
        }
    }

    public void startprintoutai() {
        System.out.println("% % % % % % % % % % begin printoutai");
        this.printoutai = true;
        this.firstprintoutai = true;
    }

    public int[] getmoveto(Graphics g, float x, float y, float z) {
        this.scr1d[0] = x;
        this.scr1d[1] = y;
        this.scr1d[2] = z;
        this.scr1d[3] = 1.0f;
        this.transform(this.scr1d);
        this.copy1d(this.cur1d, this.new1d);
        int ix = this.getpersx(this.cur1d);
        int iy = this.getpersy(this.cur1d);
        if (ix == -9999 || iy == -9999) {
            this.obs[this.nmob] = new pobj();
            ++this.nmob;
            return new int[]{-10000, -10000};
        }
        this.penx = ix;
        this.peny = iy;
        this.begx = this.penx;
        this.begy = this.peny;
        if (!this.drawasyougo && this.nmob < 1000) {
            this.obs[this.nmob] = new pobj();
            this.obs[this.nmob].p.addPoint(this.penx, this.peny);
            this.obs[this.nmob].setz(this.cur1d[2]);
            ++this.nmob;
        }
        if (this.printoutai) {
            if (this.firstprintoutai) {
                this.firstprintoutai = false;
            } else if (this.nmob > 1 && this.obs[this.nmob - 2].p.npoints == 2) {
                System.out.println("S");
            } else {
                System.out.println("n");
            }
            System.out.println(String.valueOf(this.getpersxf(this.cur1d)) + " " + this.getpersyf(this.cur1d) + " m");
        }
        return new int[]{ix, iy};
    }

    public void moveto(Graphics g, float x, float y, float z) {
        this.getmoveto(g, x, y, z);
    }

    public int[] getScreenPoint(float x, float y, float z) {
        this.scr1d[0] = x;
        this.scr1d[1] = y;
        this.scr1d[2] = z;
        this.scr1d[3] = 1.0f;
        this.transform(this.scr1d);
        this.copy1d(this.cur1d, this.new1d);
        int ix = this.getpersx(this.cur1d);
        int iy = this.getpersy(this.cur1d);
        if (ix == -9999 || iy == -9999) {
            return null;
        }
        return new int[]{ix, iy};
    }

    public float[] getScreenPointf(float x, float y, float z) {
        this.scr1d[0] = x;
        this.scr1d[1] = y;
        this.scr1d[2] = z;
        this.scr1d[3] = 1.0f;
        this.transform(this.scr1d);
        this.copy1d(this.cur1d, this.new1d);
        float fx = this.getpersxf(this.cur1d);
        float fy = this.getpersyf(this.cur1d);
        if (fx == -9999.0f || fy == -9999.0f) {
            return null;
        }
        return new float[]{fx, fy};
    }

    public int[] getlineto(Graphics g, float x, float y, float z) {
        this.scr1d[0] = x;
        this.scr1d[1] = y;
        this.scr1d[2] = z;
        this.scr1d[3] = 1.0f;
        this.transform(this.scr1d);
        int ix = this.getpersx(this.new1d);
        int iy = this.getpersy(this.new1d);
        if (ix == -9999 || iy == -9999) {
            return new int[]{-10000, -10000};
        }
        if (this.drawasyougo) {
            g.drawLine(this.penx, this.peny, ix, iy);
        }
        this.copy1d(this.cur1d, this.new1d);
        this.penx = ix;
        this.peny = iy;
        if (!this.drawasyougo && this.nmob - 1 < 1000) {
            this.obs[this.nmob - 1].p.addPoint(this.penx, this.peny);
            this.obs[this.nmob - 1].setz(this.cur1d[2]);
        }
        if (this.printoutai) {
            System.out.println(String.valueOf(this.getpersxf(this.cur1d)) + " " + this.getpersyf(this.cur1d) + " l");
        }
        return new int[]{ix, iy};
    }

    public void lineto(Graphics g, float x, float y, float z) {
        this.getlineto(g, x, y, z);
    }

    public void curveto(Graphics g, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        float a0 = this.penx;
        float b0 = this.peny;
        this.scr1d[0] = x1;
        this.scr1d[1] = y1;
        this.scr1d[2] = z1;
        this.scr1d[3] = 1.0f;
        this.transform(this.scr1d);
        float a1 = this.getpersx(this.new1d);
        float b1 = this.getpersy(this.new1d);
        this.scr1d[0] = x2;
        this.scr1d[1] = y2;
        this.scr1d[2] = z2;
        this.scr1d[3] = 1.0f;
        this.transform(this.scr1d);
        float a2 = this.getpersx(this.new1d);
        float b2 = this.getpersy(this.new1d);
        this.scr1d[0] = x3;
        this.scr1d[1] = y3;
        this.scr1d[2] = z3;
        this.scr1d[3] = 1.0f;
        this.transform(this.scr1d);
        float a3 = this.getpersx(this.new1d);
        float b3 = this.getpersy(this.new1d);
        if (this.printoutai) {
            System.out.println(String.valueOf(a1) + " " + b1 + " " + a2 + " " + b2 + " " + a3 + " " + b3 + " c");
        }
        int n = 30;
        float dt = 1.0f / (float)n;
        int penx0 = this.penx;
        int peny0 = this.peny;
        int i = 1;
        while (i <= n) {
            float t = (float)i * dt;
            float u = 1.0f - t;
            float trip = 3.0f * t * u;
            float c0 = u * u * u;
            float c1 = trip * u;
            float c2 = trip * t;
            float c3 = t * t * t;
            this.penx = (int)(c0 * a0 + c1 * a1 + c2 * a2 + c3 * a3);
            this.peny = (int)(c0 * b0 + c1 * b1 + c2 * b2 + c3 * b3);
            if (this.drawasyougo) {
                g.drawLine(penx0, peny0, this.penx, this.peny);
            } else if (this.nmob - 1 < 1000) {
                this.obs[this.nmob - 1].p.addPoint(this.penx, this.peny);
                if (i == 1) {
                    this.obs[this.nmob - 1].setz(this.new1d[2]);
                }
            }
            penx0 = this.penx;
            peny0 = this.peny;
            ++i;
        }
    }

    public void ycurveto(Graphics g, float x1, float y1, float z1, float x2, float y2, float z2) {
        float a0 = this.penx;
        float b0 = this.peny;
        this.scr1d[0] = x1;
        this.scr1d[1] = y1;
        this.scr1d[2] = z1;
        this.scr1d[3] = 1.0f;
        this.transform(this.scr1d);
        float a1 = this.getpersx(this.new1d);
        float b1 = this.getpersy(this.new1d);
        this.scr1d[0] = x2;
        this.scr1d[1] = y2;
        this.scr1d[2] = z2;
        this.scr1d[3] = 1.0f;
        this.transform(this.scr1d);
        float a2 = this.getpersx(this.new1d);
        float b2 = this.getpersy(this.new1d);
        int n = (int)(graphics3d.manhattan2(a0, b0, a1, b1) + graphics3d.manhattan2(a1, b1, a2, b2));
        if (n > 30) {
            n = 30;
        }
        if (n < 10) {
            n = 10;
        }
        float dt = 1.0f / (float)n;
        int penx0 = this.penx;
        int peny0 = this.peny;
        int i = 1;
        while (i <= n) {
            float t = (float)i * dt;
            this.penx = (int)(a0 * (1.0f - t) * (1.0f - t) + 2.0f * a1 * t * (1.0f - t) + a2 * t * t);
            this.peny = (int)(b0 * (1.0f - t) * (1.0f - t) + 2.0f * b1 * t * (1.0f - t) + b2 * t * t);
            if (this.drawasyougo) {
                g.drawLine(penx0, peny0, this.penx, this.peny);
            } else if (this.nmob - 1 < 1000) {
                this.obs[this.nmob - 1].p.addPoint(this.penx, this.peny);
                if (i == 1) {
                    this.obs[this.nmob - 1].setz(this.new1d[2]);
                }
            }
            penx0 = this.penx;
            peny0 = this.peny;
            ++i;
        }
    }

    static float manhattan2(float px, float py, float qx, float qy) {
        float dx = px - qx;
        float dy = py - qy;
        return (dx > 0.0f ? dx : -dx) + (dy > 0.0f ? dy : -dy);
    }

    public void setname(int name) {
        if (this.nmob - 1 < 1000 && this.nmob > 0) {
            this.obs[this.nmob - 1].name = name;
        }
    }

    public void setColor(Color c) {
        if (this.nmob - 1 < 1000 && this.nmob > 0) {
            this.obs[this.nmob - 1].c = c;
            this.obs[this.nmob - 1].usemycolor = true;
        }
    }

    public void closepath(Graphics g) {
        g.drawLine(this.penx, this.peny, this.begx, this.begy);
    }

    public void fillpath(Graphics g) {
        if (this.nmob > 0) {
            if (!this.obs[this.nmob - 1].usemycolor) {
                g.fillPolygon(this.obs[this.nmob - 1].p);
            } else {
                Color col = g.getColor();
                g.setColor(this.obs[this.nmob - 1].c);
                g.fillPolygon(this.obs[this.nmob - 1].p);
                g.setColor(col);
            }
        }
    }

    public void drawpath(Graphics g) {
        g.drawPolygon(this.obs[this.nmob - 1].p);
    }

    public void fillall(Graphics g) {
        int i = 0;
        while (i < this.nmob) {
            if (!this.obs[i].usemycolor) {
                g.fillPolygon(this.obs[i].p);
            } else {
                Color col = g.getColor();
                g.setColor(this.obs[i].c);
                g.fillPolygon(this.obs[i].p);
                g.setColor(col);
            }
            ++i;
        }
    }

    public void fillall(Graphics g, Color c) {
        Color col = g.getColor();
        g.setColor(c);
        int i = 0;
        while (i < this.nmob) {
            g.fillPolygon(this.obs[i].p);
            ++i;
        }
        g.setColor(col);
    }

    public Color interpolatecolor(Color c0, Color c1, float dt) {
        int r0 = c0.getRed();
        int g0 = c0.getGreen();
        int b0 = c0.getBlue();
        int r1 = c1.getRed();
        int g1 = c1.getGreen();
        int b1 = c1.getBlue();
        return new Color((int)((float)r0 + dt * (float)(r1 - r0)), (int)((float)g0 + dt * (float)(g1 - g0)), (int)((float)b0 + dt * (float)(b1 - b0)));
    }

    public void fillallbg(Graphics g, Color bg) {
        float dt = 1.0f;
        Color curc = g.getColor();
        int i = 0;
        while (i < this.nmob) {
            Color myc;
            dt = this.nmob > 1 && this.obs[this.nmob - 1].z - this.obs[0].z > 0.0f ? 0.1f + 0.9f * (this.obs[i].z - this.obs[0].z) / (this.obs[this.nmob - 1].z - this.obs[0].z) : 0.5f;
            if (!this.obs[i].usemycolor) {
                myc = this.interpolatecolor(bg, curc, dt);
                g.setColor(myc);
                g.fillPolygon(this.obs[i].p);
            } else {
                Color c = this.obs[i].c;
                myc = this.interpolatecolor(bg, c, dt);
                g.setColor(myc);
                g.fillPolygon(this.obs[i].p);
            }
            ++i;
        }
        g.setColor(curc);
    }

    public void drawallbg(Graphics g, Color bg) {
        float dt = 1.0f;
        Color curc = g.getColor();
        int i = 0;
        while (i < this.nmob) {
            if (this.nmob > 1) {
                dt = 0.1f + 0.9f * (this.obs[i].z - this.obs[0].z) / (this.obs[this.nmob - 1].z - this.obs[0].z);
            }
            Color myc = this.interpolatecolor(bg, curc, dt);
            g.setColor(myc);
            g.drawPolygon(this.obs[i].p);
            ++i;
        }
        g.setColor(curc);
    }

    public void drawall(Graphics g) {
        int i = 0;
        while (i < this.nmob) {
            g.drawPolygon(this.obs[i].p);
            ++i;
        }
    }

    public int fillmebyname(Graphics g, int name) {
        int theone = -1;
        int i = 0;
        if (name >= 0) {
            while (i < this.nmob && theone == -1) {
                if (this.obs[i].name == name) {
                    theone = i;
                }
                ++i;
            }
            if (theone > -1) {
                g.fillPolygon(this.obs[theone].p);
            }
        }
        return theone;
    }

    public int drawmebyname(Graphics g, int name) {
        int theone = -1;
        int i = 0;
        if (name >= 0) {
            while (i < this.nmob && theone == -1) {
                if (this.obs[i].name == name) {
                    theone = i;
                }
                ++i;
            }
            if (theone > -1) {
                g.drawPolygon(this.obs[theone].p);
            }
        }
        return theone;
    }

    public int fillmeallbyname(Graphics g, int name) {
        int theone = -1;
        int i = 0;
        if (name >= 0) {
            while (i < this.nmob) {
                if (this.obs[i].name == name) {
                    theone = i;
                    g.fillPolygon(this.obs[theone].p);
                }
                ++i;
            }
        }
        return theone;
    }

    public int drawmeallbyname(Graphics g, int name) {
        int theone = -1;
        int i = 0;
        if (name >= 0) {
            while (i < this.nmob) {
                if (this.obs[i].name == name) {
                    theone = i;
                    g.drawPolygon(this.obs[theone].p);
                }
                ++i;
            }
        }
        return theone;
    }

    public int hilite(Graphics g, int mx, int my) {
        int theone = this.findpoly(mx, my);
        return theone != -1 ? this.obs[theone].name : -1;
    }

    public int hilitefill(Graphics g, int mx, int my) {
        int theone = this.findpoly(mx, my);
        if (theone != -1) {
            g.fillPolygon(this.obs[theone].p);
        }
        return theone != -1 ? this.obs[theone].name : -1;
    }

    public int hilitedraw(Graphics g, int mx, int my) {
        int theone = this.findpoly(mx, my);
        if (theone != -1) {
            g.drawPolygon(this.obs[theone].p);
        }
        return theone != -1 ? this.obs[theone].name : -1;
    }

    public int hilitefilldraw(Graphics g, int mx, int my, Color c1, Color c2) {
        int theone = this.findpoly(mx, my);
        if (theone != -1) {
            g.setColor(c1);
            g.fillPolygon(this.obs[theone].p);
            g.setColor(c2);
            g.drawPolygon(this.obs[theone].p);
        }
        return theone != -1 ? this.obs[theone].name : -1;
    }

    public int findpoly(int mx, int my) {
        float zmax = -1.0E8f;
        int theone = -1;
        int i = 0;
        while (i < this.nmob) {
            if (this.obs[i].p.contains(mx, my) && this.obs[i].z > zmax) {
                zmax = this.obs[i].z;
                theone = i;
            }
            ++i;
        }
        return theone;
    }

    public int findpolyname(int mx, int my) {
        float zmax = -1.0E8f;
        int theone = -1;
        int i = 0;
        while (i < this.nmob) {
            if (this.obs[i].p.contains(mx, my) && this.obs[i].z > zmax) {
                zmax = this.obs[i].z;
                theone = this.obs[i].name;
            }
            ++i;
        }
        return theone;
    }

    public void depthsort() {
        int i = 0;
        while (i < this.nmob - 1) {
            int j = this.nmob - 1;
            while (j > i) {
                if (this.obs[j - 1].z > this.obs[j].z) {
                    pobj temp = this.obs[j - 1];
                    this.obs[j - 1] = this.obs[j];
                    this.obs[j] = temp;
                }
                --j;
            }
            ++i;
        }
    }

    public int getx() {
        return this.penx;
    }

    public int gety() {
        return this.peny;
    }

    public void addcsFrameRect(lsRect ls) {
        this.framerects.addElement(ls);
    }

    public void addlsRect(lsRect ls) {
        this.rects.addElement(ls);
    }

    public void drawcsFrameRects(Graphics g) {
        int j = 0;
        while (j < this.framerects.size()) {
            lsRect newls = (lsRect)this.framerects.elementAt(j);
            g.setColor(newls.color);
            g.drawRect(newls.x, newls.y, newls.width, newls.height);
            ++j;
        }
    }

    public void drawlsRects(Graphics g) {
        lsRect newcr;
        this.rectstemp.removeAllElements();
        int i = 0;
        while (i < this.rects.size()) {
            newcr = (lsRect)this.rects.elementAt(i);
            this.rectstemp.insertElementAt(newcr, 0);
            int j = 1;
            while (j < this.rectstemp.size()) {
                lsRect testcr = (lsRect)this.rectstemp.elementAt(j);
                if (newcr.intersects(testcr)) {
                    Rectangle rtmp = newcr.intersection(testcr);
                    int r1 = testcr.color.getRed();
                    int g1 = testcr.color.getGreen();
                    int b1 = testcr.color.getBlue();
                    int r2 = newcr.color.getRed();
                    int g2 = newcr.color.getGreen();
                    int b2 = newcr.color.getBlue();
                    float op = newcr.opacity;
                    Color ctmp = newcr.transparency == 1 ? new Color((int)((1.0f - op) * (float)r1 + op * 255.0f * (1.0f - (1.0f - (float)r1 / 255.0f) * (1.0f - (float)r2 / 255.0f))), (int)((1.0f - op) * (float)g1 + op * 255.0f * (1.0f - (1.0f - (float)g1 / 255.0f) * (1.0f - (float)g2 / 255.0f))), (int)((1.0f - op) * (float)b1 + op * 255.0f * (1.0f - (1.0f - (float)b1 / 255.0f) * (1.0f - (float)b2 / 255.0f)))) : (newcr.transparency == 3 ? newcr.color : new Color((int)((1.0f - op) * (float)r1 + op * 255.0f * ((float)r1 / 255.0f) * ((float)r2 / 255.0f)), (int)((1.0f - op) * (float)g1 + op * 255.0f * ((float)g1 / 255.0f) * ((float)g2 / 255.0f)), (int)((1.0f - op) * (float)b1 + op * 255.0f * ((float)b1 / 255.0f) * ((float)b2 / 255.0f))));
                    lsRect dtmp = new lsRect(rtmp, ctmp);
                    this.rectstemp.insertElementAt(dtmp, j + 1);
                    ++j;
                }
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.rectstemp.size()) {
            newcr = (lsRect)this.rectstemp.elementAt(j);
            g.setColor(newcr.color);
            g.fillRect(newcr.x, newcr.y, newcr.width, newcr.height);
            ++j;
        }
    }

    public int findlsRectName(int mx, int my) {
        lsRect temp;
        int i = this.framerects.size() - 1;
        while (i >= 0) {
            temp = (lsRect)this.framerects.elementAt(i);
            if (temp.contains(mx, my)) {
                return temp.id;
            }
            --i;
        }
        i = this.rects.size() - 1;
        while (i >= 0) {
            temp = (lsRect)this.rects.elementAt(i);
            if (temp.contains(mx, my)) {
                return temp.id;
            }
            --i;
        }
        return -1;
    }
}

